<?php
/*
Template Name: Blog: Standard Whole Post
*/
?>
<?php get_header(); ?>
<?php

$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_id = hudson_edge_get_page_id();
$hudson_edge_page_object = get_post( $hudson_edge_id );
$hudson_edge_content = $hudson_edge_page_object->post_content;
$hudson_edge_sidebar = hudson_edge_get_sidebar_layout();

$hudson_edge_blog_content_position = "content_above_blog_list";
if(isset($hudson_edge_options['blog_standard_type_content_position'])){
    $hudson_edge_blog_content_position = $hudson_edge_options['blog_standard_type_content_position'];
}


if(get_post_meta($hudson_edge_id, "edgt_page_background_color", true) != ""){
    $hudson_edge_background_color = 'background-color: '.esc_attr(get_post_meta($hudson_edge_id, "edgt_page_background_color", true));
}else{
    $hudson_edge_background_color = "";
}

$hudson_edge_content_style = "";
if(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true) != ""){
    if(get_post_meta($hudson_edge_id, "edgt_content-top-padding-mobile", true) == 'yes'){
        $hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px !important";
    }else{
        $hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px";
    }
}

if(isset($hudson_edge_options['blog_standard_type_number_of_chars']) && $hudson_edge_options['blog_standard_type_number_of_chars'] != "") {
    hudson_edge_set_blog_word_count(esc_attr($hudson_edge_options['blog_standard_type_number_of_chars']));
}

?>

<?php get_template_part( 'title' ); ?>
<?php get_template_part('slider'); ?>

    <div class="container" <?php hudson_edge_inline_style($hudson_edge_background_color); ?>>
			<?php if($hudson_edge_options['overlapping_content'] == 'yes') {?>
				<div class="overlapping_content"><div class="overlapping_content_inner">
			<?php } ?>
        <div class="container_inner default_template_holder" <?php hudson_edge_inline_style($hudson_edge_content_style); ?>>
            <?php if(($hudson_edge_sidebar == "default")||($hudson_edge_sidebar == "")) : ?>
                <?php
                echo apply_filters('the_content', wp_kses_post($hudson_edge_content));
                get_template_part('templates/blog/blog', 'structure');
                ?>
            <?php elseif($hudson_edge_sidebar == "1" || $hudson_edge_sidebar == "2"): ?>
				<?php
					if($hudson_edge_blog_content_position != "content_above_blog_list"){
						echo apply_filters('the_content', wp_kses_post($hudson_edge_content));
					}
				?>
                <div class="<?php if($hudson_edge_sidebar == "1"):?>two_columns_66_33<?php elseif($hudson_edge_sidebar == "2") : ?>two_columns_75_25<?php endif; ?> background_color_sidebar grid2 clearfix">
                    <div class="column1 content_left_from_sidebar">
                        <div class="column_inner">
                            <?php
							if($hudson_edge_blog_content_position == "content_above_blog_list"){
								echo apply_filters('the_content', wp_kses_post($hudson_edge_content));
							}
                            get_template_part('templates/blog/blog', 'structure');
                            ?>
                        </div>
                    </div>
                    <div class="column2">
                        <?php get_sidebar(); ?>
                    </div>
                </div>
            <?php elseif($hudson_edge_sidebar == "3" || $hudson_edge_sidebar == "4"): ?>
				<?php
					if($hudson_edge_blog_content_position != "content_above_blog_list"){
						echo apply_filters('the_content', wp_kses_post($hudson_edge_content));
					}
				?>
                <div class="<?php if($hudson_edge_sidebar == "3"):?>two_columns_33_66<?php elseif($hudson_edge_sidebar == "4") : ?>two_columns_25_75<?php endif; ?> background_color_sidebar grid2 clearfix">
                    <div class="column1">
                        <?php get_sidebar(); ?>
                    </div>
                    <div class="column2 content_right_from_sidebar">
                        <div class="column_inner">
                            <?php
                            if($hudson_edge_blog_content_position == "content_above_blog_list"){
								echo apply_filters('the_content', wp_kses_post($hudson_edge_content));
							}
                            get_template_part('templates/blog/blog', 'structure');
                            ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
				<?php if($hudson_edge_options['overlapping_content'] == 'yes') {?>
					</div></div>
				<?php } ?>
    </div>
<?php get_footer(); ?>